<%@ LANGUAGE="VBScript" %>

<% '***************************************************************************
   '* ASP Football Pool                                                       *
   '*                                                                         *
   '* Copyright 2000 by Mike Hall                                             *
   '* Please see http://www.brainjar.com for documentation and terms of use.  *
   '***************************************************************************
%>

<!-- #include file="protect.inc" -->
<!-- #include file="common.inc" -->
<!-- #include file="header.inc" -->

<% 'Open the database.

   call OpenDB()

   'Display schedule for a team, if specified.

   id = Request("id")
   if id <> "" then

     'Get team name.

     sql = "select * from Teams" _
        & " where TeamID = '" & id & "'"
     set rs = DbConn.Execute(sql)
     if not (rs.BOF and rs.EOF) then
       wins = 0
       ties = 0
       losses = 0
       str = rs.Fields("City").Value & " " & rs.Fields("Name").Value
       rs.Close
     end if %>
<p><table class="formatted" cellpadding=0 cellspacing=0>
<tr><th colspan=8><% = str %></th>
</tr>
<%   sql = "select * from Teams, Schedule" _
        & " where (VisitorID = '" & id & "' and TeamID = HomeID)" _
        & " or    (HomeID    = '" & id & "' and TeamID = VisitorID)" _
        & " order by Week"
     set rs = DbConn.Execute(sql)
     if not (rs.BOF and rs.EOF) then
       n = 0
       open = false
       do while not rs.EOF
         n = n + 1

         'Check for open date.

         if n <> rs.Fields("Week").Value then
           if Round(n / 2) * 2 <> n then %>
<tr align=right>
<%         else %>
<tr align=right class="alt">
<%         end if %>
  <td><% = n %>&nbsp;</td>
  <td colspan=2><b>Open Date</b></td>
  <td colspan=5>&nbsp;</td>
</tr>
<%         n = n + 1
           open = true
         end if

         if rs.Fields("DisplayName") <> "" then
           oppName = rs.Fields("DisplayName").Value
         else
           oppName = rs.Fields("City").Value
         end if
         result = rs.Fields("Result").Value
         if id = rs.Fields("VisitorID").Value then
           oppName = "at " & oppName
           score = rs.Fields("VisitorScore").Value
           oppScore = rs.Fields("HomeScore").Value
         else
           score = rs.Fields("HomeScore").Value
           oppScore = rs.Fields("VisitorScore").Value
         end if
         if result = id then
           result = "W"
           score = score & "-" & oppScore
           wins = wins + 1
         elseif result = TIE_STR then
           result = "T"
           score = score & "-" & oppScore
           ties = ties + 1
         elseif result <> "" then
           result = "L"
           score = score & "-" & oppScore
           losses = losses + 1
         else
           result = ""
           score = ""
         end if
         if rs.Fields("OT").Value then
           ot = "OT"
         else
           ot = ""
         end if
         if Round(n / 2) * 2 <> n then %>
<tr align=right>
<%       else %>
<tr align=right class="alt">
<%       end if %>
  <td><% = rs.Fields("Week").Value %>&nbsp;</td>
  <td><% = WeekdayName(Weekday(rs.Fields("Date").Value), true) %>&nbsp;</td>
  <td><% = FormatDate(rs.Fields("Date").Value) %>&nbsp;</td>
  <td><% = FormatTime(rs.Fields("Time").Value) %>&nbsp;</td>
  <td><% = oppName %>&nbsp;</td>
  <td align=center><% = result %>&nbsp;</td>
  <td><% = score %>&nbsp;</td>
  <td class="small"><% = ot %>&nbsp;</td>
</tr>
<%       rs.MoveNext
       loop
     end if

     'If no open date was found, it must be the last week.

     if not open then
       n = n + 1
       if Round(n / 2) * 2 <> n then %>
<tr align=right>
<%     else %>
<tr align=right class="alt">
<%     end if %>
  <td><% = n %>&nbsp;</td>
  <td colspan=2><b>Open Date</b></td>
  <td colspan=5>&nbsp;</td>
</tr>
<%   end if

     'Display record, percentage.

     if not (wins = 0 and losses = 0 and ties = 0) then
       pct = " (" & FormatNumber(Round((wins + ties / 2) / (wins + ties + losses), 3), 3, true) & ")"
     end if %>
<tr><th colspan=8 style="text-align:right;"><% = wins & "-" & losses & "-" & ties & pct %></th></tr>
</table></p>
<% end if %>

<% 'List teams. %>

<form action="<% = Request.ServerVariables("SCRIPT_NAME") %>" method="post">
<p><b>Select team:</b>
<select name="id" onchange="this.form.submit()">
  <option value="" selected></option>
<% sql = "select * from Teams order by City, Name"
   set rs = DbConn.Execute(sql)
   do while not rs.EOF %>
  <option value="<% = rs.Fields("TeamID") %>"><% = rs.Fields("City") & " " & rs.Fields("Name") %></option>
<%   rs.MoveNext
   loop %>
</select></p>
</form>

<!-- #include file="footer.inc" -->
